import { CreateUserDto } from './dto/create-user.dto';
import { UpdateUserDto } from './dto/update-user.dto';
import { User } from './entities/user.entity';
import { Repository } from 'typeorm';
import { Order } from 'src/orders/entities/order.entity';
export declare class UsersService {
    private userRepository;
    private orderRepository;
    constructor(userRepository: Repository<User>, orderRepository: Repository<Order>);
    create(createUserDto: CreateUserDto): Promise<string>;
    findAll(): Promise<User[]>;
    findOne(id: number): Promise<{
        id: number;
        document: string;
        name: string;
        email: string;
        cellphone: string;
        totalOrders: number;
        totalProducts: number;
    }>;
    findOneByEmail(email: string): Promise<User | null>;
    update(id: number, updateUserDto: UpdateUserDto): string;
    remove(id: number): Promise<string>;
}
