"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StoreProduct = void 0;
const order_item_entity_1 = require("../../order_items/entities/order_item.entity");
const product_entity_1 = require("../../products/entities/product.entity");
const stock_entity_1 = require("../../stock/entities/stock.entity");
const stock_transaction_entity_1 = require("../../stock_transactions/entities/stock_transaction.entity");
const store_entity_1 = require("../../store/entities/store.entity");
const typeorm_1 = require("typeorm");
let StoreProduct = class StoreProduct {
    id;
    product;
    store;
    stock_transaction;
    order_item;
    stock;
    custom_code;
    visible;
    price;
    highlighted;
    promotional_price;
};
exports.StoreProduct = StoreProduct;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", Number)
], StoreProduct.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => product_entity_1.Product, product => product.store_product),
    __metadata("design:type", product_entity_1.Product)
], StoreProduct.prototype, "product", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => store_entity_1.Store, store => store.store_product),
    __metadata("design:type", store_entity_1.Store)
], StoreProduct.prototype, "store", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => stock_transaction_entity_1.StockTransaction, (stockTransaction) => stockTransaction.store_product),
    __metadata("design:type", store_entity_1.Store)
], StoreProduct.prototype, "stock_transaction", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => order_item_entity_1.OrderItem, orderItem => orderItem.store_product),
    __metadata("design:type", Array)
], StoreProduct.prototype, "order_item", void 0);
__decorate([
    (0, typeorm_1.OneToOne)(() => stock_entity_1.Stock, (stock) => (stock.storeProduct)),
    __metadata("design:type", stock_entity_1.Stock)
], StoreProduct.prototype, "stock", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    __metadata("design:type", String)
], StoreProduct.prototype, "custom_code", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'boolean' }),
    __metadata("design:type", Boolean)
], StoreProduct.prototype, "visible", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'float' }),
    __metadata("design:type", Number)
], StoreProduct.prototype, "price", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'boolean' }),
    __metadata("design:type", Boolean)
], StoreProduct.prototype, "highlighted", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'integer' }),
    __metadata("design:type", Number)
], StoreProduct.prototype, "promotional_price", void 0);
exports.StoreProduct = StoreProduct = __decorate([
    (0, typeorm_1.Entity)()
], StoreProduct);
//# sourceMappingURL=store_product.entity.js.map