import { CreateStoreDto } from './dto/create-store.dto';
import { UpdateStoreDto } from './dto/update-store.dto';
import { Store } from './entities/store.entity';
import { Repository } from 'typeorm';
import { Product } from 'src/products/entities/product.entity';
import { StoreProduct } from 'src/store_products/entities/store_product.entity';
import { User } from 'src/users/entities/user.entity';
import { AdministratorsStore } from 'src/administrators_stores/entities/administrators_store.entity';
import { AddressService } from 'src/address/address.service';
import { Order } from 'src/orders/entities/order.entity';
import { StoreGateway } from './store.gateway';
import { Status } from 'src/Enums/enums';
export declare class StoresService {
    private storeRepository;
    private productsRepository;
    private storeProductRepository;
    private userRepository;
    private administratorsStore;
    private orderRepository;
    private readonly addressService;
    private readonly storeGateway;
    constructor(storeRepository: Repository<Store>, productsRepository: Repository<Product>, storeProductRepository: Repository<StoreProduct>, userRepository: Repository<User>, administratorsStore: Repository<AdministratorsStore>, orderRepository: Repository<Order>, addressService: AddressService, storeGateway: StoreGateway);
    create(createStoreDto: CreateStoreDto): Promise<string>;
    findAll(): Promise<Store[]>;
    findOrdersByStore(id: number, status: Status): Promise<any>;
    findAllByAdministrator(id: number): Promise<any[]>;
    findOne(id: number): Promise<Store | null>;
    changeOrderStatusById(id: number, status: Status): Promise<void>;
    update(id: number, updateStoreDto: UpdateStoreDto): string;
    remove(id: number): string;
}
