"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StoresModule = void 0;
const common_1 = require("@nestjs/common");
const stores_service_1 = require("./stores.service");
const stores_controller_1 = require("./stores.controller");
const typeorm_1 = require("@nestjs/typeorm");
const store_entity_1 = require("./entities/store.entity");
const product_entity_1 = require("../products/entities/product.entity");
const store_product_entity_1 = require("../store_products/entities/store_product.entity");
const jwt_1 = require("@nestjs/jwt");
const user_entity_1 = require("../users/entities/user.entity");
const administrators_store_entity_1 = require("../administrators_stores/entities/administrators_store.entity");
const address_entity_1 = require("../address/entities/address.entity");
const address_module_1 = require("../address/address.module");
const order_entity_1 = require("../orders/entities/order.entity");
const store_gateway_1 = require("./store.gateway");
const stock_entity_1 = require("../stock/entities/stock.entity");
let StoresModule = class StoresModule {
};
exports.StoresModule = StoresModule;
exports.StoresModule = StoresModule = __decorate([
    (0, common_1.Module)({
        imports: [address_module_1.AddressModule,
            typeorm_1.TypeOrmModule.forFeature([store_entity_1.Store, product_entity_1.Product, store_product_entity_1.StoreProduct, user_entity_1.User, administrators_store_entity_1.AdministratorsStore, address_entity_1.Address, order_entity_1.Order, stock_entity_1.Stock]),
            jwt_1.JwtModule.register({
                secret: process.env.JWT_SECRET || 'secret'
            })
        ],
        controllers: [stores_controller_1.StoresController],
        providers: [stores_service_1.StoresService, store_gateway_1.StoreGateway],
    })
], StoresModule);
//# sourceMappingURL=stores.module.js.map