"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StoreGateway = void 0;
const websockets_1 = require("@nestjs/websockets");
const socket_io_1 = require("socket.io");
let StoreGateway = class StoreGateway {
    server;
    handleUserRoomJoin(client, customerId) {
        if (!customerId || typeof customerId !== 'string') {
            console.warn(`ID de usuário inválido recebido: ` + JSON.stringify(customerId));
            client.emit('error', { message: 'userId inválido' });
            return;
        }
        client.join(customerId);
        console.log(`Usuário ${client.id} entrou na sala ${customerId}`);
        client.emit('room_joined', { room: customerId });
    }
    async notifyUserOrderStatusChange(userId, orderId, newStatus) {
        const sockets = await this.server.in(userId).fetchSockets();
        if (sockets.length === 0) {
            console.warn(`Nenhum socket conectado à sala do usuário ${userId}`);
            return;
        }
        console.log(`Enviando status atualizado do pedido ${orderId} ao usuário ${userId}`);
        this.server.to(userId).emit('order_status_updated', {
            orderId,
            newStatus,
        });
    }
};
exports.StoreGateway = StoreGateway;
__decorate([
    (0, websockets_1.WebSocketServer)(),
    __metadata("design:type", socket_io_1.Server)
], StoreGateway.prototype, "server", void 0);
__decorate([
    (0, websockets_1.SubscribeMessage)('status-pedido'),
    __param(0, (0, websockets_1.ConnectedSocket)()),
    __param(1, (0, websockets_1.MessageBody)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [socket_io_1.Socket, String]),
    __metadata("design:returntype", void 0)
], StoreGateway.prototype, "handleUserRoomJoin", null);
exports.StoreGateway = StoreGateway = __decorate([
    (0, websockets_1.WebSocketGateway)({
        cors: {
            origin: '*',
        },
    })
], StoreGateway);
//# sourceMappingURL=store.gateway.js.map