import { User } from 'src/users/entities/user.entity';
import { Repository, DataSource } from 'typeorm';
import { Store } from 'src/store/entities/store.entity';
import { Order } from './entities/order.entity';
import { OrderItem } from 'src/order_items/entities/order_item.entity';
import { StoreProduct } from 'src/store_products/entities/store_product.entity';
import { AsaasService } from 'src/asaas/asaas.service';
import { OrderTransactionsService } from 'src/order_transactions/order_transactions.service';
import { Status } from 'src/Enums/enums';
export declare class OrdersService {
    private orderRepository;
    private userRepository;
    private storeRepository;
    private orderItemRepository;
    private storeProductRepository;
    private readonly asaasService;
    private readonly orderTransactionService;
    private readonly dataSource;
    constructor(orderRepository: Repository<Order>, userRepository: Repository<User>, storeRepository: Repository<Store>, orderItemRepository: Repository<OrderItem>, storeProductRepository: Repository<StoreProduct>, asaasService: AsaasService, orderTransactionService: OrderTransactionsService, dataSource: DataSource);
    getOrCreateOpenOrder(userId: number, storeId: number): Promise<Order>;
    findOpenOrderByUser(userId: number): Promise<Order | null>;
    getTopProductsPerDay(storeId: number): Promise<any[]>;
    checkout(id: number): Promise<any>;
    getDetailsByOrder(id: number): Promise<any[]>;
    findPaidOrdersByUser(id: number): Promise<any[]>;
    getOrderPerHour(storeId: number, date: string): Promise<{
        hour: string;
        total: number;
    }[]>;
    findShopCartByUser(id: number): Promise<any[]>;
    changeOrderStatusById(id: number, status: Status): Promise<Order | null>;
    updateQuantityAndSubTotalOrder(orderId: number): Promise<Order | null>;
}
