"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrdersModule = void 0;
const common_1 = require("@nestjs/common");
const orders_service_1 = require("./orders.service");
const orders_controller_1 = require("./orders.controller");
const typeorm_1 = require("@nestjs/typeorm");
const order_entity_1 = require("./entities/order.entity");
const user_entity_1 = require("../users/entities/user.entity");
const store_entity_1 = require("../store/entities/store.entity");
const jwt_1 = require("@nestjs/jwt");
const order_item_entity_1 = require("../order_items/entities/order_item.entity");
const store_product_entity_1 = require("../store_products/entities/store_product.entity");
const asaas_module_1 = require("../asaas/asaas.module");
const order_transactions_module_1 = require("../order_transactions/order_transactions.module");
let OrdersModule = class OrdersModule {
};
exports.OrdersModule = OrdersModule;
exports.OrdersModule = OrdersModule = __decorate([
    (0, common_1.Module)({
        imports: [asaas_module_1.AsaasModule, order_transactions_module_1.OrderTransactionsModule,
            typeorm_1.TypeOrmModule.forFeature([order_entity_1.Order, user_entity_1.User, store_entity_1.Store, order_item_entity_1.OrderItem, store_product_entity_1.StoreProduct]),
            jwt_1.JwtModule.register({
                secret: process.env.JWT_SECRET || 'secret'
            })
        ],
        controllers: [orders_controller_1.OrdersController],
        providers: [orders_service_1.OrdersService],
        exports: [orders_service_1.OrdersService]
    })
], OrdersModule);
//# sourceMappingURL=orders.module.js.map