"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrdersController = void 0;
const common_1 = require("@nestjs/common");
const orders_service_1 = require("./orders.service");
const enums_1 = require("../Enums/enums");
let OrdersController = class OrdersController {
    ordersService;
    constructor(ordersService) {
        this.ordersService = ordersService;
    }
    getOrdersPerHour(storeId, date) {
        return this.ordersService.getOrderPerHour(+storeId, date);
    }
    getTopProductsPerDay(storeId) {
        return this.ordersService.getTopProductsPerDay(+storeId);
    }
    preCheckout(id) {
        return this.ordersService.checkout(+id);
    }
    getDetailsByOrder(id) {
        return this.ordersService.getDetailsByOrder(+id);
    }
    getMyPaidOrders(id) {
        return this.ordersService.findPaidOrdersByUser(+id);
    }
    findShopCartByUser(id) {
        return this.ordersService.findShopCartByUser(+id);
    }
    changeOrderStatusById(id, status) {
        return this.ordersService.changeOrderStatusById(+id, status);
    }
};
exports.OrdersController = OrdersController;
__decorate([
    (0, common_1.Get)('/pedidos-por-hora/'),
    __param(0, (0, common_1.Query)('store')),
    __param(1, (0, common_1.Query)('date')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], OrdersController.prototype, "getOrdersPerHour", null);
__decorate([
    (0, common_1.Get)('/top-produtos/'),
    __param(0, (0, common_1.Query)('store')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], OrdersController.prototype, "getTopProductsPerDay", null);
__decorate([
    (0, common_1.Get)('/finalizar-pedido/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], OrdersController.prototype, "preCheckout", null);
__decorate([
    (0, common_1.Get)('/detalhes-pedido/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], OrdersController.prototype, "getDetailsByOrder", null);
__decorate([
    (0, common_1.Get)('/meus-pedidos/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], OrdersController.prototype, "getMyPaidOrders", null);
__decorate([
    (0, common_1.Get)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], OrdersController.prototype, "findShopCartByUser", null);
__decorate([
    (0, common_1.Patch)('status-pedido/:id/'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('status')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], OrdersController.prototype, "changeOrderStatusById", null);
exports.OrdersController = OrdersController = __decorate([
    (0, common_1.Controller)('pedidos'),
    __metadata("design:paramtypes", [orders_service_1.OrdersService])
], OrdersController);
//# sourceMappingURL=orders.controller.js.map