"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrderItemsService = void 0;
const common_1 = require("@nestjs/common");
const orders_service_1 = require("../orders/orders.service");
const typeorm_1 = require("@nestjs/typeorm");
const order_item_entity_1 = require("./entities/order_item.entity");
const typeorm_2 = require("typeorm");
const store_product_entity_1 = require("../store_products/entities/store_product.entity");
const user_entity_1 = require("../users/entities/user.entity");
const order_entity_1 = require("../orders/entities/order.entity");
const enums_1 = require("../Enums/enums");
let OrderItemsService = class OrderItemsService {
    orderRepository;
    orderItemRepository;
    storeProduct;
    userRepository;
    ordersService;
    constructor(orderRepository, orderItemRepository, storeProduct, userRepository, ordersService) {
        this.orderRepository = orderRepository;
        this.orderItemRepository = orderItemRepository;
        this.storeProduct = storeProduct;
        this.userRepository = userRepository;
        this.ordersService = ordersService;
    }
    async create(createOrderItemDto) {
        const storeProduct = await this.storeProduct.findOne({
            where: {
                id: createOrderItemDto.storeProductId
            },
            relations: ['store']
        });
        if (!storeProduct) {
            throw new common_1.NotFoundException("Ops. Produto não encontrado");
        }
        const order = await this.ordersService.getOrCreateOpenOrder(createOrderItemDto.user, storeProduct?.store.id);
        const existingItem = await this.orderItemRepository.findOne({
            where: {
                order: { id: order.id },
                store_product: { id: createOrderItemDto.storeProductId },
            },
        });
        try {
            if (existingItem) {
                existingItem.quantity += createOrderItemDto.quantity;
                await this.orderItemRepository.save(existingItem);
                this.ordersService.updateQuantityAndSubTotalOrder(order.id);
            }
            else {
                const newItem = this.orderItemRepository.create({
                    order: { id: order.id },
                    store_product: { id: createOrderItemDto.storeProductId },
                    quantity: createOrderItemDto.quantity,
                });
                try {
                    await this.orderItemRepository.save(newItem);
                    this.ordersService.updateQuantityAndSubTotalOrder(order.id);
                }
                catch (error) {
                    throw new common_1.BadRequestException("Ops. Erro ao tentar adicionar o item ao carrinho");
                }
            }
        }
        catch (error) {
            throw new common_1.BadRequestException("Ops. Erro ao adicionar produto ao carrinho");
        }
        return "Produto adicionado ao carrinho";
    }
    async countByUser(id) {
        const user = await this.userRepository.findOneBy({ id });
        if (!user) {
            throw new common_1.NotFoundException("Ops. Não foi possível localizar um usuário com o ID informado");
        }
        return await this.orderItemRepository
            .createQueryBuilder('oi')
            .innerJoin('oi.order', 'o')
            .select('SUM(oi.quantity)', 'total_quantity')
            .where('o.userId = :id', { id })
            .getRawOne();
    }
    async updateItemQuantity(id, updateOrderItemDto) {
        const user = this.userRepository.findOneBy({ id: updateOrderItemDto.user });
        if (!user) {
            throw new common_1.NotFoundException("Ops. Não foi possível localizar um usuário com o ID informado");
        }
        const orderItem = await this.orderItemRepository
            .createQueryBuilder('orderItem')
            .innerJoin('orderItem.order', 'order')
            .innerJoin('order.user', 'user')
            .select([
            'orderItem.id',
            'orderItem.orderId AS orderId'
        ])
            .where('userId = :id and storeProductId = :storeProductId and status = :status', { id: updateOrderItemDto.user, storeProductId: updateOrderItemDto.storeProductId, status: enums_1.Status.OPEN })
            .getRawOne();
        if (!orderItem) {
            throw new common_1.NotFoundException("Ops. Não foi possível localizar esse item no carrinho do usuário");
        }
        switch (updateOrderItemDto.operation) {
            case "add":
                await this.orderItemRepository.increment({ id: orderItem.orderItem_id }, 'quantity', 1);
                this.ordersService.updateQuantityAndSubTotalOrder(orderItem.orderId);
                console.log("Quantidade incrementada com sucesso");
                break;
            case "reduce":
                await this.orderItemRepository.decrement({ id: orderItem.orderItem_id }, 'quantity', 1);
                this.ordersService.updateQuantityAndSubTotalOrder(orderItem.orderId);
                console.log("Quantidade decrementada com sucesso");
                break;
            case "custom":
                await this.orderItemRepository.update(orderItem.orderItem_id, {
                    quantity: updateOrderItemDto.quantity,
                });
                this.ordersService.updateQuantityAndSubTotalOrder(orderItem.orderId);
                console.log("Quantidade alterada com sucesso");
                break;
            default:
                throw new common_1.BadRequestException("Ops. Um ou mais dados estão incorretos ou incompletos. Não foi possível atualizar a quantidade do produto");
        }
        return await this.orderItemRepository.findOneOrFail({
            where: {
                id: orderItem.orderItem_id
            },
            select: ['quantity']
        });
    }
    async remove(id, prodId) {
        const order_item = await this.orderItemRepository.findOne({
            where: {
                store_product: { id: prodId },
                order: {
                    user: { id: id },
                    status: enums_1.Status.OPEN,
                },
            },
            relations: ['order', 'order.user'],
        });
        if (!order_item) {
            throw new common_1.NotFoundException("Ops. O produto informado não está presente no carrinho deste usuário");
        }
        try {
            this.orderItemRepository.remove(order_item);
        }
        catch (error) {
            throw new common_1.BadRequestException("Ops. Erro ao tentar remover produto do carrinho");
        }
        return "Produto removido com sucesso";
    }
};
exports.OrderItemsService = OrderItemsService;
exports.OrderItemsService = OrderItemsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(order_entity_1.Order)),
    __param(1, (0, typeorm_1.InjectRepository)(order_item_entity_1.OrderItem)),
    __param(2, (0, typeorm_1.InjectRepository)(store_product_entity_1.StoreProduct)),
    __param(3, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        orders_service_1.OrdersService])
], OrderItemsService);
//# sourceMappingURL=order_items.service.js.map