"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrderItemsController = void 0;
const common_1 = require("@nestjs/common");
const order_items_service_1 = require("./order_items.service");
const create_order_item_dto_1 = require("./dto/create-order_item.dto");
const update_order_item_dto_1 = require("./dto/update-order_item.dto");
let OrderItemsController = class OrderItemsController {
    orderItemsService;
    constructor(orderItemsService) {
        this.orderItemsService = orderItemsService;
    }
    create(createOrderItemDto, req) {
        console.log(req.body);
        return this.orderItemsService.create(createOrderItemDto);
    }
    countByUser(id) {
        return this.orderItemsService.countByUser(+id);
    }
    updateItemQuantity(id, updateOrderItemDto) {
        return this.orderItemsService.updateItemQuantity(+id, updateOrderItemDto);
    }
    remove(id, prodId) {
        return this.orderItemsService.remove(+id, +prodId);
    }
};
exports.OrderItemsController = OrderItemsController;
__decorate([
    (0, common_1.Post)('/registro'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_order_item_dto_1.CreateOrderItemDto, Request]),
    __metadata("design:returntype", void 0)
], OrderItemsController.prototype, "create", null);
__decorate([
    (0, common_1.Get)('/total-produtos/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], OrderItemsController.prototype, "countByUser", null);
__decorate([
    (0, common_1.Patch)('/alterar-quantidade/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_order_item_dto_1.UpdateOrderItemDto]),
    __metadata("design:returntype", void 0)
], OrderItemsController.prototype, "updateItemQuantity", null);
__decorate([
    (0, common_1.Delete)(':id/remove/:prodId'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Param)('prodId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], OrderItemsController.prototype, "remove", null);
exports.OrderItemsController = OrderItemsController = __decorate([
    (0, common_1.Controller)('item-pedido'),
    __metadata("design:paramtypes", [order_items_service_1.OrderItemsService])
], OrderItemsController);
//# sourceMappingURL=order_items.controller.js.map