"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthService = void 0;
const common_1 = require("@nestjs/common");
const jwt_1 = require("@nestjs/jwt");
const typeorm_1 = require("@nestjs/typeorm");
const bcrypt = require("bcrypt");
const address_service_1 = require("../address/address.service");
const store_entity_1 = require("../store/entities/store.entity");
const users_service_1 = require("../users/users.service");
const typeorm_2 = require("typeorm");
let AuthService = class AuthService {
    storeRepository;
    jwtService;
    usersService;
    addressService;
    constructor(storeRepository, jwtService, usersService, addressService) {
        this.storeRepository = storeRepository;
        this.jwtService = jwtService;
        this.usersService = usersService;
        this.addressService = addressService;
    }
    async validateUser(email, password) {
        const user = await this.usersService.findOneByEmail(email);
        if (user && bcrypt.compareSync(password, user.password)) {
            return user;
        }
        return null;
    }
    async login(user) {
        let addressInfo = null;
        try {
            addressInfo = await this.addressService.findStoreNearByUser({ origem: "interno", id: user.id });
        }
        catch (error) {
            console.log(error);
        }
        const payload = { email: user.email, id: user.id, role: user.role };
        return {
            ...(addressInfo ?? {}),
            acess_token: this.jwtService.sign(payload),
        };
    }
    async validateStore(email, password) {
        const store = await this.storeRepository.findOneBy({ email });
        if (store && bcrypt.compareSync(password, store.password)) {
            return store;
        }
        return null;
    }
    async storeLogin(store) {
        const payload = { id: store.id, email: store.email, name: store.store_name };
        return {
            acess_token: this.jwtService.sign(payload)
        };
    }
};
exports.AuthService = AuthService;
exports.AuthService = AuthService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(store_entity_1.Store)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        jwt_1.JwtService,
        users_service_1.UsersService,
        address_service_1.AddressService])
], AuthService);
//# sourceMappingURL=auth.service.js.map