import { JwtService } from '@nestjs/jwt';
import { AddressService } from 'src/address/address.service';
import { Store } from 'src/store/entities/store.entity';
import { UsersService } from 'src/users/users.service';
import { Repository } from 'typeorm';
export declare class AuthService {
    private storeRepository;
    private jwtService;
    private usersService;
    private addressService;
    constructor(storeRepository: Repository<Store>, jwtService: JwtService, usersService: UsersService, addressService: AddressService);
    validateUser(email: string, password: string): Promise<import("../users/entities/user.entity").User | null>;
    login(user: {
        email: string;
        id: number;
        role: string;
    }): Promise<{
        acess_token: string;
        store?: {
            id: number;
            zipCode: string;
            addressName: string;
        } | undefined;
        zipCode?: string | undefined;
    }>;
    validateStore(email: string, password: string): Promise<Store | null>;
    storeLogin(store: {
        id: number;
        email: string;
        store_name: string;
    }): Promise<{
        acess_token: string;
    }>;
}
