"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsaasService = void 0;
const axios_1 = require("@nestjs/axios");
const common_1 = require("@nestjs/common");
const rxjs_1 = require("rxjs");
const asaas_gateway_1 = require("./asaas.gateway");
const typeorm_1 = require("@nestjs/typeorm");
const user_entity_1 = require("../users/entities/user.entity");
const typeorm_2 = require("typeorm");
const order_entity_1 = require("../orders/entities/order.entity");
const order_transactions_service_1 = require("../order_transactions/order_transactions.service");
const enums_1 = require("../Enums/enums");
let AsaasService = class AsaasService {
    userRepository;
    orderRepository;
    http;
    asaasGateway;
    orderTransactionService;
    baseURL = process.env.ASAAS_BASE_SANDBOX_URL;
    constructor(userRepository, orderRepository, http, asaasGateway, orderTransactionService) {
        this.userRepository = userRepository;
        this.orderRepository = orderRepository;
        this.http = http;
        this.asaasGateway = asaasGateway;
        this.orderTransactionService = orderTransactionService;
    }
    async paymentNotify(body) {
        if (true) {
            this.asaasGateway.sendConfirmedPayment("123", "cus_000006914333", "PAYD");
            this.asaasGateway.notifyStoreNewOrder("20");
            const order = await this.orderRepository
                .createQueryBuilder('order')
                .innerJoin('order.user', 'user')
                .where('user.assas_customer_code = "cus_000006914333" and order.status = :status', { status: enums_1.Status.OPEN })
                .getOne();
            if (!order) {
                throw new common_1.NotFoundException("Ops. Pedido não encontrado");
            }
            const orderPaid = order.status = enums_1.Status.PAID;
            this.orderRepository.update(order.id, { status: orderPaid });
            this.orderTransactionService.create(order, enums_1.Status.PAID);
        }
    }
    getHeaders() {
        return {
            accept: 'application/json',
            'access_token': process.env.ASSAS_API_SANDBOX_KEY,
            'content-type': 'application/json',
        };
    }
    getExpirationDate(minutes = 20) {
        const date = new Date();
        date.setMinutes(date.getMinutes() + minutes);
        return date.toISOString();
    }
    async createLeanPayment(createLeanDto) {
        const headers = this.getHeaders();
        const seatchClient = await (0, rxjs_1.firstValueFrom)(this.http.get(`${this.baseURL}/customers`, {
            headers,
            params: { cpfCnpj: createLeanDto.cpfCnpj },
        }));
        let customerId;
        if (seatchClient.data.totalCount > 0) {
            customerId = seatchClient.data.data[0].id;
        }
        else {
            const newClient = await (0, rxjs_1.firstValueFrom)(this.http.post(`${this.baseURL}/customers`, {
                name: createLeanDto.name,
                cpfCnpj: createLeanDto.cpfCnpj,
                email: createLeanDto.email,
                mobilePhone: createLeanDto.mobilePhone,
            }, { headers }));
            customerId = newClient.data.id;
            const user = await this.userRepository.findOneBy({ document: createLeanDto.cpfCnpj });
            if (!user) {
                throw new common_1.NotFoundException("Ops. Usuário não encontrado");
            }
            try {
                const userWithCustomerId = user.assas_customer_code = newClient.data.id;
                await this.userRepository.update(user.id, { assas_customer_code: userWithCustomerId });
            }
            catch (error) {
                throw new Error(error);
            }
        }
        const existPayment = await (0, rxjs_1.firstValueFrom)(this.http.get(`${this.baseURL}/payments`, {
            headers,
            params: {
                customer: customerId,
                status: 'PENDING',
            },
        }));
        for (const billing of existPayment.data.data) {
            await (0, rxjs_1.firstValueFrom)(this.http.delete(`${this.baseURL}/payments/${billing.id}`, {
                headers
            }));
        }
        const expirationDate = this.getExpirationDate();
        const payment = {
            customer: customerId,
            billingType: 'PIX',
            value: createLeanDto.value,
            dueDate: expirationDate,
            description: 'Cobrança via API Lean',
            pix: {
                expirationDate,
            },
        };
        let paymentId;
        try {
            const response = await (0, rxjs_1.firstValueFrom)(this.http.post(`${this.baseURL}/lean/payments`, payment, { headers }));
            paymentId = response.data.id;
        }
        catch (error) {
            console.error('Erro ao criar pagamento Lean:', error?.response?.data || error.message);
            throw error;
        }
        try {
            const payload = await (0, rxjs_1.firstValueFrom)(this.http.get(`${this.baseURL}/payments/${paymentId}/pixQrCode`, { headers }));
            return {
                customerId,
                paymentId: paymentId,
                qrCodeImageUrl: payload.data?.encodedImage || null,
                qrCodePayload: payload.data?.payload || null,
                raw: payload.data,
            };
        }
        catch (error) {
            throw new common_1.BadRequestException("Erro ao enviar dados para pagamento");
        }
        ;
    }
};
exports.AsaasService = AsaasService;
exports.AsaasService = AsaasService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __param(1, (0, typeorm_1.InjectRepository)(order_entity_1.Order)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        axios_1.HttpService,
        asaas_gateway_1.AsaasGateway,
        order_transactions_service_1.OrderTransactionsService])
], AsaasService);
//# sourceMappingURL=asaas.service.js.map