"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddressService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const address_entity_1 = require("./entities/address.entity");
const typeorm_2 = require("typeorm");
const axios_1 = require("@nestjs/axios");
const rxjs_1 = require("rxjs");
const user_entity_1 = require("../users/entities/user.entity");
const order_entity_1 = require("../orders/entities/order.entity");
const enums_1 = require("../Enums/enums");
let AddressService = class AddressService {
    addressRepository;
    userRepository;
    orderRepository;
    httpService;
    constructor(addressRepository, userRepository, orderRepository, httpService) {
        this.addressRepository = addressRepository;
        this.userRepository = userRepository;
        this.orderRepository = orderRepository;
        this.httpService = httpService;
    }
    async create(createAddressDto) {
        if (!createAddressDto.user) {
            if (!createAddressDto.store) {
                throw new common_1.NotFoundException("O endereço deve estar associado a alguma entidade");
            }
            else {
                const addressResponse = (await this.findCepAPI(createAddressDto.zipCode, 2));
                if (addressResponse.status != 200) {
                    throw new common_1.BadRequestException("Ops. Endereço da unidade inexistente");
                }
                const address = addressResponse.data;
                const addressStoreCreated = this.addressRepository.create({
                    store: { id: createAddressDto.store },
                    state: address.uf,
                    city: address.cidade,
                    neighboor: address.bairro,
                    street: address.logradouro,
                    zip_code: address.cep,
                    number: createAddressDto.number,
                    complement: createAddressDto.complement ?? "",
                    reference: createAddressDto.reference ?? "",
                    name_address: createAddressDto.name_address
                });
                try {
                    return await this.addressRepository.save(addressStoreCreated);
                }
                catch (error) {
                    throw new common_1.BadRequestException("Erro ao testar salvar endereço da loja");
                }
            }
        }
        const user = this.userRepository.findOneBy({ id: createAddressDto.user });
        if (!user) {
            throw new common_1.NotFoundException("Ops. Usuário referenciado não existe");
        }
        let address;
        try {
            const url = process.env.FIND_CEP_URL + `v1/cep/${createAddressDto.zipCode}.json`;
            const response = await (0, rxjs_1.firstValueFrom)(this.httpService.get(url, {
                headers: {
                    'Referer': 'EG97MZ17QGI3V'
                },
            }));
            address = response.data;
        }
        catch (error) {
            const axiosError = error;
            if (axiosError.response) {
                throw new common_1.HttpException(axiosError.response.data, axiosError.response.status);
            }
            throw new common_1.HttpException('Erro ao buscar CEP', 500);
        }
        if (!address) {
            throw new common_1.NotFoundException("Ops. Não foi possível localizar esse endereço");
        }
        const createdAddress = this.addressRepository.create({
            user: { id: createAddressDto.user },
            state: address.uf,
            city: address.cidade,
            neighboor: address.bairro,
            street: address.logradouro,
            zip_code: address.cep,
            number: createAddressDto.number,
            complement: createAddressDto.complement,
            reference: createAddressDto.reference,
            name_address: createAddressDto.name_address,
        });
        return await this.addressRepository.save(createdAddress);
    }
    async findAllByUser(id) {
        const user = await this.userRepository.findOneBy({ id });
        if (!user) {
            throw new common_1.NotFoundException("Ops. Usuário não encontrado");
        }
        const enderecos = await this.addressRepository.find({
            where: {
                user: { id }
            }
        });
        if (!enderecos) {
            throw new common_1.NotFoundException("Ops. Nenhum usuário encontrdo para este usuário");
        }
        return enderecos;
    }
    async findStoreNearByUser(id) {
        let userZipCode;
        let userId;
        if (id.origem == "externo") {
            const address = await this.addressRepository.findOne({
                where: {
                    id: id.id,
                    user: (0, typeorm_2.Not)(!(0, typeorm_2.IsNull)())
                },
                relations: ['user'],
            });
            if (!address) {
                throw new common_1.NotFoundException("Ops. Endereço inexistente");
            }
            userZipCode = address.zip_code;
            userId = address.user.id;
            if (!userId) {
                throw new common_1.NotFoundException("Ops. Endereço não possui usuário");
            }
        }
        if (id.origem === "interno") {
            const user = await this.userRepository.findOneBy({ id: id.id });
            if (!user) {
                throw new common_1.NotFoundException("Ops. Usuário não encontrado");
            }
            const address = await this.addressRepository.findOne({
                where: {
                    user: { id: id.id },
                    favorite: true
                },
            });
            if (!address) {
                throw new common_1.NotFoundException("Ops. Endereço favorito não encontrado");
            }
            userZipCode = address.zip_code;
        }
        const stores = await this.addressRepository
            .createQueryBuilder('address')
            .innerJoin('address.store', 'store')
            .select([
            'address.store.id AS id',
            'address.zip_code AS zipCode',
            'address.name_address AS nameAddress',
        ])
            .where('storeId IS NOT NULL')
            .getRawMany();
        console.log("User Zip Code" + userZipCode);
        console.log(JSON.stringify(stores, null, 2));
        if (stores.length == 0) {
            throw new common_1.NotFoundException("Ops. Nenhum endereço de lojas encontrado");
        }
        const nearestStoreAddress = this.calculateDistance(userZipCode, stores);
        if (!(await nearestStoreAddress).store.id || !(await nearestStoreAddress).store.zipCode || !(await nearestStoreAddress).zipCode) {
            throw new common_1.BadRequestException("Ops. Não foi possível obter o ID da loja mais próxima");
        }
        try {
            const order = await this.orderRepository.findOne({
                where: {
                    user: { id: id.origem == "interno" || userId },
                    status: enums_1.Status.OPEN,
                },
                relations: ['user'],
            });
            if (!order) {
                console.warn("Ops. Nenhum pedido aberto localizado para esse usuário");
            }
            else {
                await this.orderRepository.update(order.id, {
                    store: (await nearestStoreAddress).store.id,
                });
            }
        }
        catch (error) {
            console.error("Erro ao buscar ou atualizar pedido:", error);
        }
        return nearestStoreAddress;
    }
    async update(id, updateAddressDto) {
        const user = await this.userRepository.findOneBy({ id });
        const address = await this.addressRepository.findOne({
            where: {
                id: updateAddressDto.address_id,
                user: { id: user?.id }
            }
        });
        if (!user) {
            throw new common_1.NotFoundException("Ops. Usuário não encontrado");
        }
        if (!address) {
            throw new common_1.NotFoundException("Ops. Não foi possível encontrar o endereço especificado");
        }
        if (address.favorite == true) {
            throw new common_1.ConflictException("Ops. Parece que esse endereço já é o favorito");
        }
        const existFavoriteAddress = await this.addressRepository.findOne({
            where: {
                user: { id: user.id },
                favorite: true
            }
        });
        if (existFavoriteAddress) {
            try {
                await this.addressRepository.update(existFavoriteAddress.id, { favorite: false });
            }
            catch (error) {
                throw new common_1.BadRequestException("Ops. Não foi possível mudar o status do favorito. ", error);
            }
        }
        try {
            await this.addressRepository.update(address.id, { favorite: true });
            return "Novo endereço favoritado com sucesso!";
        }
        catch (error) {
            throw new common_1.BadRequestException("Ops. Não foi possível favoritar um novo endereço", error);
        }
    }
    async remove(id, enderecoId) {
        const user = await this.userRepository.findOneBy({ id });
        if (!user) {
            throw new common_1.NotFoundException("Ops. Usuário não encontrado");
        }
        const existAddress = await this.addressRepository.findOne({
            where: {
                id: enderecoId,
                user: { id }
            }
        });
        if (!existAddress) {
            throw new common_1.NotFoundException("Ops. Endereço não encontrado");
        }
        if (existAddress.favorite === true) {
            throw new common_1.BadRequestException("Ops. Não é possível excluir o endereço favorito");
        }
        try {
            await this.addressRepository.remove(existAddress);
            return "Endereço removido";
        }
        catch (error) {
            throw new common_1.BadRequestException("Ops. Não foi possível remover o endereço");
        }
    }
    async calculateDistance(userZipCode, storeZipCodes) {
        const { lat: userLat, lon: userLon } = (await this.findCepAPI(userZipCode, 1)).data.location;
        let closestDistance;
        let closestStoreId, closestStoreZipCode, closestStoreAddressName;
        for (let zipCode of storeZipCodes) {
            let { lat: storeLat, lon: storeLon } = (await this.findCepAPI(zipCode.zipCode, 1)).data.location;
            const R = 6371000;
            const toRad = (value) => (value * Math.PI) / 180;
            const dLat = toRad(userLat - storeLat);
            const dLon = toRad(storeLon - userLon);
            const a = Math.sin(dLat / 2) ** 2 +
                Math.cos(toRad(userLat)) * Math.cos(toRad(storeLat)) * Math.sin(dLon / 2) ** 2;
            const c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
            let distance = R * c;
            if (!closestDistance || closestDistance > distance) {
                closestDistance = distance;
                closestStoreId = zipCode.id;
                closestStoreZipCode = zipCode.zipCode;
                closestStoreAddressName = zipCode.nameAddress;
            }
            ;
        }
        return {
            store: {
                id: closestStoreId,
                zipCode: closestStoreZipCode,
                addressName: closestStoreAddressName
            },
            zipCode: userZipCode
        };
    }
    async findCepAPI(zipCode, option) {
        let restantUrl;
        switch (option) {
            case 1:
                restantUrl = `v1/geolocation/cep/${zipCode}`;
                break;
            case 2:
                restantUrl = `v1/cep/${zipCode}.json`;
                break;
        }
        const url = process.env.FIND_CEP_URL + restantUrl;
        console.log(url);
        try {
            const response = await (0, rxjs_1.firstValueFrom)(this.httpService.get(url, {
                headers: {
                    'Referer': String(process.env.FID)
                },
            }));
            console.log(response.data);
            return response;
        }
        catch (error) {
            throw new common_1.BadRequestException("Erro ao tentar comunicar-se com a API Find CEP. \n Erro: " + error);
        }
    }
};
exports.AddressService = AddressService;
exports.AddressService = AddressService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(address_entity_1.Address)),
    __param(1, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __param(2, (0, typeorm_1.InjectRepository)(order_entity_1.Order)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        axios_1.HttpService])
], AddressService);
//# sourceMappingURL=address.service.js.map